//
//  ReaderProtocol.h
//  IOS-SDK
//
//  Created by Vital on 28/04/16.
//  Copyright © 2016 Zetes SA/NV. All rights reserved.
//
#import <Foundation/Foundation.h>

@protocol ReaderProtocol <NSObject>

/*!
 @method lastName
 @discussion
 This method reads the ID data file from card and decodes the last name of the eID.
 @result
 utf8 String containing last name
 */
- (NSString *) lastName;

/*!
 @method firstName
 @discussion
 This method reads the ID data file from card and decodes the first name of the eID.
 @result
 utf8 String containing first name
 */
- (NSString *) firstName;

/*!
 @method thirdName
 @discussion
 This method reads the ID data file from card and decodes the first character of the third name of the eID.
 @result
 String containing first character of third name
 */
- (NSString *) thirdName;

/*!
 @method cardDeliveryMunicipality
 @discussion
 This method reads the address data file from card and decodes municipality of delivery of the card
 @result
 utf8 String containing municipality where card was delivered.
 */
- (NSString *) cardDeliveryMunicipality;


/*!
 @method cardNumber
 @discussion
 This method reads eID data file from card and decodes cardnumber
 @result
 String containing cardnumber
 */
- (NSString *) cardNumber;

/*!
 @method cardValidFrom
 @discussion
 @result
 String containing start of validity period for eID card data
 */
- (NSString *) cardValidFrom;

/*!
 @method cardValidTo
 @discussion
 @result
 String containing end of validity period for eID card data
 */
- (NSString *) cardValidTo;

/*!
 @method chipNumber
 @discussion
 @result
 String containing chipnumber of eID card
 */
- (NSString *) chipNumber;

/*!
 @method nationality
 @discussion
 This method reads the id data of eID card and decodes the nationality of eID card owner.
 This string can be encoded in different languages, mostly depending on card delivery municipality.
 (e.g. België - Belgiën - Belgique)
 @result
 String containing nationality of eID card owner
 */
- (NSString *) nationality;

/*!
 @method placeOfBirth
 @discussion
 @result
 String containing place of birth of eID card owner
 */
- (NSString *) placeOfBirth;

/*!
 @method sex
 @discussion
 @result
 String containing sex of eID card owner.
 */
- (NSString *) sex;

/*!
 @method dateOfBirth
 @discussion
 @result
 String containing the date of birth of eID Card owner. This string contains the string data as it is encoded on card. See also NSDateOfBirth which returns a NSDate object.
 */
- (NSString *) dateOfBirth;

/*!
 @method NSDateOfBirth
 @discussion
 @result
 NSDate* containing the date of birth of eID Card owner. This method translates the date on an eid card to a NSDate object
 */
- (NSDate *) NSDateOfBirth;

/*!
 @method dateOfBirthWithFormat:localIdentifier:
 @discussion
 @result
 NSDate* containing the date of birth of eID Card owner. This method returns a string formatted with format and specified local identifier
 */
- (NSString *) dateOfBirthWithFormat:(NSString*) format localIdentifier:(NSString*) localID;


/*!
 @method natNumber
 @discussion
 The National security number should be used with caution.
 Special permission from Belgian government is needed to use/store this number in databases related applications!
 @result
 String containing the national security number of the eID card owner
 */
- (NSString *) natNumber;

/*!
 @method address
 @discussion
 
 @result
 String containing street and number
 */
- (NSString *) address;

/*!
 @method postalCode
 @discussion
 @result
 String containing the postal code of the eID card owner
 */
- (NSString *) postalCode;

/*!
 @method municipality
 @discussion
 @result
 String containing the municipality of the eID card owner
 */
- (NSString *) municipality;

/*!
 @method specialStatus
 @discussion
 
 @result
 String for specialStatus
 */
- (int) specialStatus;

/*!
 @method nobleCondition
 @discussion
 
 @result
 String for nobleCondition
 */
- (NSString *) nobleCondition;

/*!
 @method specialOrganisation
 @discussion
 
 @result
 String for specialOrganisation
 */
- (NSString *) specialOrganisation;

/*!
 @method memberOfFamily
 @discussion
 
 @result
 String for memberOfFamily
 */
- (NSString *) memberOfFamily;

/*!
 @method duplicate
 @discussion
 
 @result
 int for duplicate
 */
- (int) duplicate;

/*!
 @method photoDigest
 @discussion
 
 @result
 NSData* for photoDigest
 */
- (NSData*) photoDigest;

/*!
 @method docTypeInt
 @discussion
 
 @result
 int for eID type
 */
- (int) docTypeInt;

+ (NSString *) docTypeToString: (int) i;

/*!
@method workPermitMention
@discussion

@result
int for work permit mention
*/
- (NSString *) workPermitMention;

/*!
@method dateAndCountryOfProtection
@discussion

@result
String for Date and Country Of Protection
*/
- (NSString *) dateAndCountryOfProtection;

/*!
@method vatNumber1
@discussion

@result
String  for VAT Number 1
*/
- (NSString *) vatNumber1;

/*!
@method vatNumber2
@discussion

@result
String  for VAT Number 2
*/
- (NSString *) vatNumber2;

/*!
@method regionNumber
@discussion

@result
String  for region number
*/
- (NSString *) regionNumber;


/*!
 @method idFile
 @discussion
 raw idFile
 @result
 NSData buffer containing raw id data
 */
- (NSData*) idFile;

/*!
 @method idSigFile
 @discussion
 raw idSigFile
 @result
 NSData buffer containing raw id signature data
 */
- (NSData*) idSigFile;

/*!
 @method addressFile
 @discussion
 raw addressFile
 @result
 NSData buffer containing raw address data
 */
- (NSData*) addressFile;

/*!
 @method addressSigFile
 @discussion
 raw addressSigFile
 @result
 NSData buffer containing raw address signature data
 */
- (NSData*) addressSigFile;

/*!
 @method picture
 @discussion
 Picture in black and white is stored on eID card and is around 3kb in size.
 @result
 NSData buffer containing jpeg data of picture of eID card owner
 */
- (NSData*) picture;

- (NSData*) authenticationCertificate;

/*!
 @method nonrepudiationCertificate
 @discussion
 The national eID card contains 2 user rsa public-private keypairs.
 The authentication key (and public key certificate) is used in authentication schemes such as used in tax-on-web.
 The non-repudiation key is used in signature schemes for legally binding qualified signatures as in document signing.
 This method reads the public non-repudiation key certificate and returns its X509v3 representation.
 @result
 NSData buffer containing the binary X509v3 representation of the non-repudiation certificate.
 */
- (NSData*) nonrepudiationCertificate;

/*!
 @method caCertificate
 @discussion
 The user public key certificates are signed by an intermediate CA certificate and this intermediate CA certificate is signed by the national root certificate.
 This method reads the public intermediate ca certificate and returns its X509v3 representation.
 @result
 NSData buffer containing the binary X509v3 representation of the CA certificate.
 */
- (NSData*) caCertificate;

/*!
 @method rootCaCertificate
 @discussion
 The user public key certificates are signed by an intermediate CA certificate and this intermediate CA certificate is signed by the national root certificate.
 This method reads the root ca certificate and returns its X509v3 representation.
 @result
 NSData buffer containing the binary X509v3 representation of the root certificate.
 */
- (NSData*) rootCaCertificate;

/*!
 @method rrnCertificate
 @discussion
 This method reads the rrn certificate and returns its X509v3 representation.
 @result
 NSData buffer containing the binary X509v3 representation of the root certificate.
 */
- (NSData*) rrnCertificate;


@end
