//
//  ViewController.m
//  IOS-SDK-Demo
//
//  Created by Vital on 6/01/15.
//  Copyright (c) 2015 Schonkeren. All rights reserved.
//

#import "ViewController.h"
#import "eID_SDK.h"
#import "Reader.h"



@interface ViewController () <ReaderDelegate, UIPickerViewDataSource, UIPickerViewDelegate>

@property (weak, nonatomic) IBOutlet UIPickerView *deviceType;
@property (weak, nonatomic) NSString* currentDeviceType;
@property (weak, nonatomic) IBOutlet UITextField *sdkVersion;
@property (weak, nonatomic) IBOutlet UITextField *firstName;
@property (weak, nonatomic) IBOutlet UITextField *lastName;
@property (weak, nonatomic) IBOutlet UIImageView *photo;
@property (strong, nonatomic) Reader *eidReader;
@property (weak, nonatomic) IBOutlet UIActivityIndicatorView *indicator;
@property (strong, nonatomic) NSArray* deviceTypes;

@end

@implementation ViewController


//#define MODE_MANUAL 1

- (void)viewDidLoad {
   [super viewDidLoad];
   // Do any additional setup after loading the view, typically from a nib.
   self.sdkVersion.text = [NSString stringWithFormat:@"%@ (%@)", [eID_SDK sdkVersion], [eID_SDK sdkReleaseDate] ];
   
   //add following to receive notifications when app goes to background or becomes active again
   [[NSNotificationCenter defaultCenter] addObserver:self
                                            selector:@selector(appBecomesActive)
                                                name:UIApplicationDidBecomeActiveNotification object:nil];
   [[NSNotificationCenter defaultCenter] addObserver:self
                                            selector:@selector(appWillResignActive)
                                                name:UIApplicationWillResignActiveNotification object:nil];
   self.deviceType.dataSource = self;
   self.deviceType.delegate = self;
   
   self.deviceTypes = @[@"BLE", @"IR301_AND_BR301", @"UNDEFINED"];
   self.currentDeviceType = @"BLE";
}

- (void) didDetectReader: (NSString*) reader
{
   NSLog(@"Demo: did detect reader: %@", reader);
}

//following two functions will stop and start the reader context so the reader stays on during use of the app and will shutdown
//when the app goes to background. The reader will automatically shutdown after 2 minutes of inuse.
- (void) appWillResignActive
{
   //NSLog(@"appWillResignActive");
#if !MODE_MANUAL
    [self.eidReader close];
   [self.eidReader stopScan];
#endif
}

- (void) appBecomesActive
{
#if !MODE_MANUAL
   if (self.eidReader == nil) {

      //OPTION 1. no deviceType specified
      //in this case we will connect to the bt3 reader if it is powered at moment of startScan, otherwise we will scan for BLE readers on startup
      //however, if started with BT3 reader on, it will after a disconnect, scan for both readertypes
      //this situation is a bit unclear for the user and it is better to define which type of reader to support
      //self.eidReader = [[Reader alloc] initWithPreferredReader : @"FT_ANY" OEM:nil];

      //OPTION 2. each reader has a unique specific name starting with FT_
      //specify the FT_ name for the reader and scanning will only happen for this specific reader
      //this filter on FT_ name is only effective for BLE readers, since BT3 readers need to pair anyhow, which makes filtering unnecessary
      //self.eidReader = [[Reader alloc] initWithPreferredReader : @"FT_C4ED587A7C96" OEM:nil];
      
      //OPTION 3. in this case we will only scan for readers iR301 and bt3
      //self.eidReader = [[Reader alloc] initWithPreferredReader : @"FT_ANY" OEM:nil type:@"IR301_AND_BR301"];
      
      //OPTION 4. in this case we will only scan for connected readers BLE readers
      //default min RSSI=-65 this is approx. 1m distance between reader and ios device
      self.eidReader = [[Reader alloc] initWithPreferredReader: @"FT_ANY" OEM:@"" type:@"BLE" minRSSI:-60];

      //receive evens like reader detected or card inserted/removed
      self.eidReader.delegate = self;
   }
   else {
      [self.eidReader startScan];
   }
#endif
}


- (int) open
{
   int iRet = [self.eidReader open];
   
   dispatch_async(dispatch_get_main_queue(), ^{
      UIAlertController* alert = [[UIAlertController alloc]init];
      [alert addAction:[UIAlertAction actionWithTitle:@"Close" style:UIAlertActionStyleDefault
                                               handler:^(UIAlertAction * action) {}]];

      if (alert.popoverPresentationController) {
         // for iPAD only
         CGRect rect = CGRectMake(self.view.bounds.size.width/2,self.view.bounds.size.height/2, 0,0);
         alert.popoverPresentationController.sourceRect = rect;
         alert.popoverPresentationController.sourceView = self.view;
         alert.popoverPresentationController.permittedArrowDirections = 0;
      }

      switch (iRet){
            
         case 0:
            break;
         case E_READER_NOT_SUPPORTED:
            [alert setTitle:@"Reader not supported"];
            [alert setMessage:@"Your reader is not supported by eID-SDK"];
            [self presentViewController:alert animated:YES completion:nil];
            //self.eidReader = nil;
            break;
         case E_READER_NOT_PRESENT:
            [alert setTitle:@"(Specified) Reader not found"];
            [alert setMessage:@"Please attach reader"];
            //self.eidReader = nil;
            [self presentViewController:alert animated:YES completion:nil];
            break;
         case E_CARD_NOT_PRESENT:
            [alert setTitle:@"No card inserted"];
            [alert setMessage:@"Please insert your eID"];
            [self presentViewController:alert animated:YES completion:nil];
            //self.eidReader = nil;
            break;
          case E_CARD_NOT_SUPPORTED:
            [alert setTitle:@"Card unsupported"];
            [alert setMessage:@"Please insert valid eID and in the correct orientation"];
            [self presentViewController:alert animated:YES completion:nil];
            //self.eidReader = nil;
            break;
         default:;
      }
   });
   
   return iRet;
}

- (void) close
{
   [self.eidReader close];
}

- (IBAction)ReadEid:(id)sender
{
    
#if MODE_MANUAL
    self.eidReader = [[Reader alloc] initWithPreferredReader: @"FT_ANY" OEM:@"" type:@"BLE"];
    [self.eidReader startScan];
#endif
    
   dispatch_async(dispatch_get_global_queue(0,0), ^{
      
      dispatch_async(dispatch_get_main_queue(), ^{
         self.firstName.text = nil;
         self.lastName.text = nil;
         [[self photo] setImage:nil];
         [self.indicator startAnimating];
      });
      
      int iRet = [self open];
      if (iRet) {
         dispatch_async(dispatch_get_main_queue(), ^{
            [self.indicator stopAnimating];
         });
         return;
      }
      
      NSString* firstName = self.eidReader.firstName;
      NSString* lastname = self.eidReader.lastName;
  
      NSLog(@"Document type: %@", [Reader docTypeToString: self.eidReader.docTypeInt]);
      /*NSLog(@"dateAndCountryOfProtection: %@", self.eidReader.dateAndCountryOfProtection);
      NSLog(@"workPermitMention: %@", self.eidReader.workPermitMention);
      NSLog(@"vat number 1: %@", self.eidReader.vatNumber1);
      NSLog(@"vat number 2: %@", self.eidReader.vatNumber2);
      NSLog(@"region Nr: %@", self.eidReader.regionNumber);*/

      dispatch_async(dispatch_get_main_queue(), ^{
         self.firstName.text = firstName;
         self.lastName.text = lastname;
      });
      
#if (0)
      NSData* authenticationCertificate = [[NSData alloc] initWithData:self.eidReader.authenticationCertificate];
      NSLog( @"auth certificate: %@", authenticationCertificate);
      NSData* nonrepudiationCertificate = [[NSData alloc] initWithData:self.eidReader.nonrepudiationCertificate];
      NSLog( @"non-repudiation certificate: %@", nonrepudiationCertificate);
      NSData* caCertificate = [[NSData alloc] initWithData:self.eidReader.caCertificate];
      NSLog( @"ca certificate: %@", caCertificate);
      NSData* rootCaCertificate = [[NSData alloc] initWithData:self.eidReader.rootCaCertificate];
      NSLog( @"root certificate: %@", rootCaCertificate);
#endif
      
      UIImage* picture = [[UIImage alloc ] initWithData:self.eidReader.picture];
      
      dispatch_async(dispatch_get_main_queue(), ^{
         [[self photo] setImage:picture];
         [self.indicator stopAnimating];
      });
       
     [self.eidReader close];

#if MODE_MANUAL
    [self.eidReader stopScan];
    self.eidReader = nil;
#endif
   });
}

//ReaderDelagates

- (void) readerDidChange:(BOOL)attached
{
    if (attached == FALSE) {
        dispatch_async(dispatch_get_main_queue(), ^{
           NSLog(@"Demo: reader detached");
           //make sure card data is cleared
           self.firstName.text = nil;
           self.lastName.text = nil;
           [[self photo] setImage:nil];
        });
    }
    else {
       NSLog(@"Demo: reader attached");
    }
}

- (void) cardDidChange:(BOOL)attached
{
    if (attached == FALSE) {
        dispatch_async(dispatch_get_main_queue(), ^{
           NSLog(@"Demo: card removed");
           NSLog(@"Demo: GUI stuff must be on the main queue");
            self.firstName.text = nil;
            self.lastName.text = nil;
            [[self photo] setImage:nil];

        });
    }
    else {
      NSLog(@"Demo: card attached: start reading eID");
      NSLog(@"");
      [self ReadEid:self];
    }
}

#pragma mark "delegates for pickerView"
- (NSInteger)numberOfComponentsInPickerView:(nonnull UIPickerView *)pickerView {
   return 1;
}

- (NSInteger)pickerView:(nonnull UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component {
   return self.deviceTypes.count;
}

- (NSString*)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
   NSString* deviceType = self.deviceTypes[row];
   return deviceType;
}

- (void) pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component {
   
   self.currentDeviceType = self.deviceTypes[row];
   
   if ([self.currentDeviceType isEqualToString:@"UNDEFINED"]) {
      self.currentDeviceType = @"";
   }
   
   [self.eidReader close];
   //[self.eidReader stopScan];
   self.eidReader = nil;
  
   [NSThread sleepForTimeInterval:1];
   
    self.eidReader = [[Reader alloc] initWithPreferredReader : @"FT_ANY" OEM:@"" type:self.currentDeviceType];
    
   self.eidReader.delegate = self;
}

@end
