package be.zetes.eiddemo;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import be.zetes.zseidlib.ZsEidLib;
import be.zetes.zseidlib.reader.CardStatus;


public class ScRdrDialog extends Dialog {

   private final static String TAG = "ZseidLib_DEMO";

   private Context mContext;

   private TextView tvMessage;

   private ZsEidLib mHandleLib;

   private ProgressBarCallback mProgressBarCallback;

   private ZsEidLib.OnCardReaderEventListener mReaderEventListener = new ZsEidLib.OnCardReaderEventListener() {
      @Override
      public void onReaderConnected(String readerName) {
         Log.d(TAG, "onReaderConnected: " + readerName);

         setTitle("Please insert eID card...");
         tvMessage.setText("Wait for eID card...");
      }

      @Override
      public void onReaderDisconnected(String readerName) {
         Log.d(TAG, "onReaderDisconnected: " + readerName);
         tvMessage.setText("Wachten op eID-lezer...");
         mHandleLib.startScanning();
      }
   };

   private ZsEidLib.OnCardEventListener mCardEventListener = new ZsEidLib.OnCardEventListener() {
      @Override
      public void onCardInserted() {
         Log.d(TAG, "onCardInserted");

         if (mProgressBarCallback != null) {
            mProgressBarCallback.onWaitForReaderTerminated(1);
         }

         dismiss();
      }

      @Override
      public void onCardRemoved() {
         Log.d(TAG, "onCardRemoved");
      }
   };

   public void setEidLib(ZsEidLib ZsEidLib) {
      mHandleLib = ZsEidLib;
   }

   public ScRdrDialog(@NonNull Context context) {
      super(context);
      mContext = context;
   }

   public ScRdrDialog(@NonNull Context context, int themeResId) {
      super(context, themeResId);
      mContext = context;
   }

   protected ScRdrDialog(@NonNull Context context, boolean cancelable, @Nullable OnCancelListener cancelListener) {
      super(context, cancelable, cancelListener);
      mContext = context;
   }

   @Override
   protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);

      Log.d(TAG, "onCreate");

      mHandleLib.registerReaderEventListener(mReaderEventListener);
      mHandleLib.registerCardEventListener(mCardEventListener);

      setContentView(R.layout.custdialog_layout);

      tvMessage = (TextView) findViewById(R.id.textViewCL);

      if (!mHandleLib.isValidReader()) {
         setTitle("Please connect BlueTooth Reader (BLE)...");
         tvMessage.setText("Waiting for eID reader...");
      }
      else if (mHandleLib.getCardStatus().equals(CardStatus.CardAbsent)) {
         setTitle("Please insert eID  ...");
         tvMessage.setText("Waiting for eID card ...");
      }
      else {
         // reader and card present
         quitDialog();
      }

      Button button = (Button) findViewById(R.id.buttonOK);
      button.setText("Cancel");
      button.setOnClickListener(new View.OnClickListener() {
         @Override
         public void onClick(View view) {
            mHandleLib.stopScanning();

            if (mProgressBarCallback != null) {
               mProgressBarCallback.onWaitForReaderTerminated(0);
            }

            dismiss();
         }
      });

      mHandleLib.startScanning();
   }

   public void quitDialog() {
      if (mProgressBarCallback != null) {
         mProgressBarCallback.onWaitForReaderTerminated(1);
      }

      dismiss();
   }

   @Override
   public void dismiss() {
      Log.d(TAG, "ScRdrDialog dismiss");

      mHandleLib.unregisterReaderEventListener(mReaderEventListener);
      mHandleLib.unregisterCardEventListener(mCardEventListener);

      super.dismiss();
   }

   /**
    * A callback used when progress bar is dismissed (Cancel or Card Inserted).
    */
   public interface ProgressBarCallback {
      void onWaitForReaderTerminated(int retCode);
   }

   public void registerProgressBarCallback(ProgressBarCallback progressBarCallback) {
      mProgressBarCallback = progressBarCallback;
   }

}
