package be.zetes.eiddemo;

import android.app.ProgressDialog;
import android.os.AsyncTask;
import android.util.Log;

import java.security.MessageDigest;

//import be.zetes.zsbleidlib.ZsBleIdLib;
//import be.zetes.zsbleidlib.beid.Address;
//import be.zetes.zsbleidlib.beid.HashAlgo;
//import be.zetes.zsbleidlib.beid.Identity;
//import be.zetes.zsbleidlib.beid.KeyType;
//import be.zetes.zsbleidlib.domain.ReturnCode;

import be.zetes.zseidlib.ZsEidLib;
import be.zetes.zseidlib.domain.ReturnCode;
import be.zetes.zseidlib.beid.*;
import be.zetes.zseidlib.reader.CardStatus;


public class ReadEidAsyncTask extends AsyncTask<Void, Void, EidData> {

   private final static String TAG = "ZsEidLib_DEMO";

   private ProgressDialog progressDialog;
   private ZsEidLib mLib;

   private ReadEidAsyncTaskDelegates readEidAsyncTaskDelegates = null;

   public interface ReadEidAsyncTaskDelegates {
      void didReadEidAsyncTaskFinished(EidData eidData);
   }

   public void registerDelegates(ReadEidAsyncTaskDelegates readEidAsyncTaskDelegates) {
      this.readEidAsyncTaskDelegates = readEidAsyncTaskDelegates;
   }

   public ReadEidAsyncTask(ProgressDialog progressDialog, ZsEidLib zsEidLib) {
      this.progressDialog = progressDialog;
      this.mLib = zsEidLib;
   }

   private void showProgressDialog() {
      Log.d(TAG, "Show Progress Bar....");
      if (!progressDialog.isShowing()) {
         progressDialog.show();
      }
   }

   private void closeProgressDialog() {
      if (progressDialog.isShowing()) {
         Log.d(TAG, "Closing Progress Bar....");
         progressDialog.dismiss();
      }
   }

   public static String toFormattedHexDump(byte[] bytes, int bytesPerLine) {
      if (bytes == null || bytes.length == 0) {
         return "";
      }
      StringBuilder hexString = new StringBuilder();
      for (int i = 0; i < bytes.length; i++) {
         hexString.append(String.format("%02X ", bytes[i]));
         if ((i + 1) % bytesPerLine == 0) {
            hexString.append("\n");
         }
      }
      return hexString.toString().trim();
   }
   private byte[] hash(String algo, String data) {
      try {
         // Create Hash
         MessageDigest digest = java.security.MessageDigest.getInstance(algo);
         digest.update(data.getBytes());
         byte messageDigest[] = digest.digest();

         return messageDigest;
      } catch (Exception ex) {
         return null;
      }
   }

   @Override
   protected EidData doInBackground(Void... voids) {

      EidData result = EidData.create();

      try {
         // Calls onProgressUpdate()
         this.publishProgress();

         CardStatus cs = mLib.getCardStatus();
         Log.d(TAG, "Card status 1 " + cs); // => UNKNOWN = PRESENT but INACTIVE (before poweronCard)

         Log.d(TAG, "PowerOn");
         ReturnCode rc = mLib.powerOnCard();
         if (rc != ReturnCode.OK) {
            Log.d(TAG, "PowerOn NOK");

            result.setError("NOK");
            return result;
         }

         cs = mLib.getCardStatus();
         Log.d(TAG, "Card status 1 " + cs);
         Log.d(TAG, "PowerOn OK");

         Log.d(TAG, "reading id");
         Identity identity = mLib.getIdentity();
         Log.d(TAG, "getIdentity - getLastError: " + mLib.getLastError());

         Log.d(TAG, "reading address");
         Address address = mLib.getAddress();
         Log.d(TAG, "getAddress - getLastError: " + mLib.getLastError());

         Log.d(TAG, "reading pic");
         byte[] pic = mLib.getPicture();
         Log.d(TAG, "getPicture - getLastError: " + mLib.getLastError());

         if ((identity == null) || (address == null) || (pic == null)) {
            Log.d(TAG, "Identity, Address or PIC NOK");

            result.setError("NOK");
         } else {
            result.setIdentity(identity);
            result.setAddress(address);
            result.setPicData(pic);

            result.setError("OK");
         }

//         X509Certificate auth = mLib.getAuthenticationCertificate();
//         if (auth != null) {
//            Log.d(TAG, "auth = " + auth.getSubjectDN().getName());
//         }
//         X509Certificate nonrep = mLib.getNonRepudiationCertificate();
//         if (auth != null) {
//            Log.d(TAG, "nonrep = " + nonrep.getSubjectDN().getName());
//         }
//         X509Certificate subca = mLib.getSubCACertificate();
//         if (auth != null) {
//            Log.d(TAG, "subca = " + subca.getSubjectDN().getName());
//         }
//         X509Certificate rootca = mLib.getRootCACertificate();
//         if (auth != null) {
//            Log.d(TAG, "rootca = " + rootca.getSubjectDN().getName());
//         }
//
    /*      rc = mLib.verifyPin("1234", KeyType.KT_AUTHENTICATION_KEY);
         Log.d(TAG, "verify pin: " + rc);

         byte[] signature = mLib.getSignature(HashAlgo.HASH_ALGO_SHA_256, hash("SHA256", "TESTDATA"));
         if (signature != null) {
            Log.d(TAG, "signature length = " + signature.length);
            Log.d(TAG, "Hex Dump: " + toFormattedHexDump(signature, 16));
         } else {
            Log.d(TAG, "signature ->length = 0");
         }
*/

      } catch (Exception ex) {
         result.setError(ex.toString());
      }

      return result;
   }

   @Override
   protected void onProgressUpdate(Void... values) {
      showProgressDialog();
   }

   @Override
   protected void onPostExecute(EidData result) {
      closeProgressDialog();

      if (readEidAsyncTaskDelegates != null) {
         readEidAsyncTaskDelegates.didReadEidAsyncTaskFinished(result);
      }
   }

}
