package be.zetes.eiddemo;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;

import androidx.core.app.ActivityCompat;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import be.zetes.zseidlib.ZsEidLib;
import be.zetes.zseidlib.domain.ReturnCode;
import be.zetes.zseidlib.reader.CardStatus;

public class MainActivity extends AppCompatActivity implements ScRdrDialog.ProgressBarCallback, ReadEidAsyncTask.ReadEidAsyncTaskDelegates {

   private final static String TAG = "ZsEidIdLib_DEMO";
   private Context mContext;
   private ZsEidLib mHandle;

   private ProgressDialog progressDialog;
   private ImageView ivPhoto;
   private TextView tvCardNumber;
   private TextView tvChipNumber;
   private TextView tvCardValidityDateBegin;
   private TextView tvCardValidityDateEnd;
   private TextView tvCardDeliveryMunicipality;
   private TextView tvNationalNumber;
   private TextView tvName;
   private TextView tvNationality;
   private TextView tvOther;
   private TextView tvAddress;

   @Override
   protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.activity_main);
      Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
      setSupportActionBar(toolbar);

      FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
      fab.setOnClickListener(new View.OnClickListener() {
         @Override
         public void onClick(View view) {
            Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
         }
      });

      mContext = this;
      final Activity activity = this;

      String[] appPermissions = null;
      if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
         appPermissions = new String[]{
                 Manifest.permission.BLUETOOTH_SCAN,
                 Manifest.permission.BLUETOOTH_CONNECT
         };
      }
      else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
         appPermissions = new String[]{
                 Manifest.permission.ACCESS_FINE_LOCATION
         };
      }

      if (appPermissions != null) {
         final AlertDialog.Builder builder = new AlertDialog.Builder(this);
         builder.setTitle("Request for bluetooth access");
         builder.setMessage("Please grant access so this app can detect bluetooth devices.");
         builder.setPositiveButton("OK", null);
         String[] finalAppPermissions = appPermissions;
         builder.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
               ActivityCompat.requestPermissions(activity, finalAppPermissions, 0);
            }
         });
         builder.show();
      }

      ivPhoto = (ImageView) findViewById(R.id.imageView);

      tvCardNumber = (TextView) findViewById(R.id.tvCardNumber);
      tvChipNumber = (TextView) findViewById(R.id.tvChipNumber);
      tvCardValidityDateBegin = (TextView) findViewById(R.id.tvCardValidityDateBegin);
      tvCardValidityDateEnd = (TextView) findViewById(R.id.tvCardValidityDateEnd);
      tvCardDeliveryMunicipality = (TextView) findViewById(R.id.tvCardDeliveryMunicipality);
      tvNationalNumber = (TextView) findViewById(R.id.tvNationalNumber);
      tvName = (TextView) findViewById(R.id.tvName);
      tvNationality = (TextView) findViewById(R.id.tvNationality);
      tvOther = (TextView) findViewById(R.id.tvOther);

      tvAddress = (TextView) findViewById(R.id.tvAddress);

      if (!getPackageManager().hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE)) {
         Toast.makeText(this, R.string.ble_not_supported, Toast.LENGTH_SHORT).show();
         finish();
      }

      mHandle = new ZsEidLib(this);
   }

   @Override
   protected void onResume() {
      super.onResume();

      progressDialog = new ProgressDialog(this);
      progressDialog.setTitle("Reading eID data");
      progressDialog.setMessage("Please wait...");

      //rssi_threshold defines how close the reader should be in the range of the phone before the reader is found
      //once connected, the reader keeps the connection as far as the max BLE range for that reader

      //default rssi_threshold = -64 (approx 50-100cm depending somehow on device)
      ReturnCode rc = mHandle.initSDK(null, null, -64);
      Log.d(TAG, "initSDK - " + rc);

//      mHandle.registerReaderEventListener(new ZsEidLib.OnCardReaderEventListener() {
//         @Override
//         public void onReaderConnected(String readerName) {
//            Log.d(TAG, "onReaderConnected: " + readerName);
//         }
//
//         @Override
//         public void onReaderDisconnected(String readerName) {
//            Log.d(TAG, "onReaderDisconnected: " + readerName);
//         }
//      });
//      clearFields();
   }

   @Override
   protected void onPause() {
      super.onPause();

      ReturnCode rc = mHandle.closeSDK();
      Log.d(TAG, "closeSDK - " + rc);
   }

   @Override
   public boolean onCreateOptionsMenu(Menu menu) {
      // Inflate the menu; this adds items to the action bar if it is present.
      getMenuInflater().inflate(R.menu.menu_main, menu);
      return true;
   }

   @Override
   public boolean onOptionsItemSelected(MenuItem item) {
      // Handle action bar item clicks here. The action bar will
      // automatically handle clicks on the Home/Up button, so long
      // as you specify a parent activity in AndroidManifest.xml.
      int id = item.getItemId();

      //noinspection SimplifiableIfStatement
      if (id == R.id.action_settings) {
         return true;
      }

      return super.onOptionsItemSelected(item);
   }

   private static final int REQUEST_ENABLE_BT = 1;

   protected void onActivityResult(int requestCode, int resultCode, Intent data) {
      super.onActivityResult(requestCode, resultCode, data);
      if (requestCode == REQUEST_ENABLE_BT) {
         if (resultCode == RESULT_OK) {

      //      this.showReaderDialog();
         }
      }
   }

   public void onRead(View view) {
      Log.d(TAG, "onRead");

      clearFields();

      BluetoothAdapter bluetoothAdapter;
      // Initializes Bluetooth adapter.
      final BluetoothManager bluetoothManager = (BluetoothManager) getSystemService(Context.BLUETOOTH_SERVICE);
      bluetoothAdapter = bluetoothManager.getAdapter();
      // Ensures Bluetooth is available on the device and it is enabled. If not,
      // displays a dialog requesting user permission to enable Bluetooth.
      if (bluetoothAdapter == null || !bluetoothAdapter.isEnabled()) {
         Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
         if (ActivityCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED) {
            // TODO: Consider calling
            //    ActivityCompat#requestPermissions
            // here to request the missing permissions, and then overriding
            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
            //                                          int[] grantResults)
            // to handle the case where the user grants the permission. See the documentation
            // for ActivityCompat#requestPermissions for more details.
            return;
         }
         startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);
      }
      else {
         if (mHandle.getCardStatus().equals(CardStatus.CardPresent)) {
            // just start reading, card is present and powered
            onWaitForReaderTerminated(1);
         }
         else {
            ScRdrDialog scRdrDialog = new ScRdrDialog(mContext, R.style.FilterDialogTheme);
            scRdrDialog.setEidLib(mHandle);
            scRdrDialog.registerProgressBarCallback(this);
            scRdrDialog.setCanceledOnTouchOutside(false);
            scRdrDialog.show();
         }
      }
   }


   @Override
   public void onWaitForReaderTerminated(int retCode) {
      switch (retCode) {
         case 0:
            Log.d(TAG, "onWaitForReaderTerminated: Cancel...");

            ReturnCode rc = mHandle.closeReader();
            Log.d(TAG, "Closing reader: " + rc);

            break;
         case 1:
            Log.d(TAG, "onWaitForReaderTerminated: Card present...");

            ReadEidAsyncTask readEidAsyncTask = new ReadEidAsyncTask(progressDialog, mHandle);
            readEidAsyncTask.registerDelegates(this);
            readEidAsyncTask.execute();

            break;
      }
   }

   private void clearFields() {
      ivPhoto.setImageBitmap(null);

      tvCardNumber.setText("");
      tvChipNumber.setText("");
      tvCardValidityDateBegin.setText("");
      tvCardValidityDateEnd.setText("");
      tvCardDeliveryMunicipality.setText("");
      tvNationalNumber.setText("");
      tvName.setText("");
      tvNationality.setText("");
      tvOther.setText("");

      tvAddress.setText("");
   }

   @Override
   public void didReadEidAsyncTaskFinished(EidData eidData) {
      if (eidData.getError().equals("OK")) {

         //
         // Picture
         //
         Bitmap bitmap = BitmapFactory.decodeByteArray(eidData.getPicData(), 0, eidData.getPicData().length);
         ivPhoto.setImageBitmap(bitmap);

         //
         // Identity
         //
         tvCardNumber.setText(eidData.getIdentity().cardNumber);
         tvChipNumber.setText(eidData.getIdentity().chipNumber);
         tvCardValidityDateBegin.setText(eidData.getIdentity().cardValidityDateBegin);
         tvCardValidityDateEnd.setText(eidData.getIdentity().cardValidityDateEnd);
         tvCardDeliveryMunicipality.setText(eidData.getIdentity().cardDeliveryMunicipality);
         tvNationalNumber.setText(eidData.getIdentity().nationalNumber);
         String name = eidData.getIdentity().name;
         if (eidData.getIdentity().firstName != null) {
            name += " - " + eidData.getIdentity().firstName;
         }
         if (eidData.getIdentity().otherName != null) {
            name += " - " + eidData.getIdentity().otherName;
         }
         tvName.setText(name);
         tvNationality.setText(eidData.getIdentity().nationality);
         tvOther.setText(eidData.getIdentity().sex + " - " + eidData.getIdentity().birthDate + " - " + eidData.getIdentity().birthLocation);

         //
         // Address
         //
         tvAddress.setText(eidData.getAddress().streetAndNumber + " - " + eidData.getAddress().zip + " " + eidData.getAddress().municipality);

         //foreigener card extra fields (work permit)
         Log.d(TAG, "dateAndCountryOfProtection" + eidData.getIdentity().dateAndCountryOfProtection);
         Log.d(TAG, "work permit" + eidData.getIdentity().workPermitMention);
         Log.d(TAG, "vatnumber1" + eidData.getIdentity().vatNumber1);
         Log.d(TAG, "vatnumber2" + eidData.getIdentity().vatNumber2);
         Log.d(TAG, "region number" + eidData.getIdentity().regionNumber);


      } else {
         tvCardNumber.setText(eidData.getError());
      }

      // Closing the handle here will cause the reader to poweroff
      // ReturnCode rc = mHandle.closeReader();
      //Log.d(TAG, "Closing reader: " + rc);
   }
}
